<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        if (! Schema::hasColumn('appointments', 'date')) {
            Schema::table('appointments', function (Blueprint $table) {
                // add the `date` column if missing
                $table->dateTime('date')->nullable()->after('id');
            });
        }
    }

    public function down(): void
    {
        if (Schema::hasColumn('appointments', 'date')) {
            Schema::table('appointments', function (Blueprint $table) {
                $table->dropColumn('date');
            });
        }
    }
};
