<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        if (! Schema::hasColumn('patients', 'age_months')) {
            Schema::table('patients', function (Blueprint $table) {
                $table->unsignedTinyInteger('age_months')->nullable()->after('age');
            });
        }
    }

    public function down(): void
    {
        if (Schema::hasColumn('patients', 'age_months')) {
            Schema::table('patients', function (Blueprint $table) {
                $table->dropColumn('age_months');
            });
        }
    }
};
