<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});

use App\Http\Controllers\Api\PatientController;
use App\Http\Controllers\Api\OwnerController;
use App\Http\Controllers\Api\VeterinarianController;
use App\Http\Controllers\Api\MedicineController;
use App\Http\Controllers\Api\AppointmentController;
use App\Http\Controllers\Api\DoctorChargePresetController;
use App\Http\Controllers\Api\AuthController;
use App\Http\Controllers\Api\StockController;
use App\Http\Controllers\Api\PatientReportController;
use App\Http\Controllers\Api\PatientVaccinationController;

// Keep backwards-compatible routes at /api/<resource>
// preview next passbook number (placed before resource to avoid route parameter conflicts)
Route::get('patients/next-passbook', [PatientController::class, 'nextPassbook']);
Route::apiResource('patients', PatientController::class);
Route::get('patients/{patient}/vaccinations', [PatientVaccinationController::class, 'index']);
Route::post('patients/{patient}/vaccinations', [PatientVaccinationController::class, 'store']);
Route::patch('patient-vaccinations/{patientVaccination}', [PatientVaccinationController::class, 'update']);
Route::delete('patient-vaccinations/{patientVaccination}', [PatientVaccinationController::class, 'destroy']);
Route::post('appointments/{appointment}/send-invoice', [AppointmentController::class, 'sendInvoiceSms']);
// doctor charge presets (full CRUD)
Route::apiResource('doctor-charge-presets', DoctorChargePresetController::class)->only(['index','store','update','destroy']);
Route::apiResource('owners', OwnerController::class);
Route::apiResource('veterinarians', VeterinarianController::class);
Route::apiResource('medicines', MedicineController::class);
Route::apiResource('stock', StockController::class);
Route::apiResource('appointments', AppointmentController::class);
Route::get('patient-reports', [PatientReportController::class, 'index']);
Route::post('patient-reports/sync', [PatientReportController::class, 'sync']);

// auth routes (token-based)
Route::post('login', [AuthController::class, 'login']);
Route::middleware('auth:sanctum')->post('logout', [AuthController::class, 'logout']);

// Also expose v1 prefix (optional)
Route::prefix('v1')->group(function () {
    // preview next passbook number under v1 as well (placed before resource)
    Route::get('patients/next-passbook', [PatientController::class, 'nextPassbook']);
    Route::apiResource('patients', PatientController::class);
    Route::get('patients/{patient}/vaccinations', [PatientVaccinationController::class, 'index']);
    Route::post('patients/{patient}/vaccinations', [PatientVaccinationController::class, 'store']);
    Route::patch('patient-vaccinations/{patientVaccination}', [PatientVaccinationController::class, 'update']);
    Route::delete('patient-vaccinations/{patientVaccination}', [PatientVaccinationController::class, 'destroy']);
    Route::post('appointments/{appointment}/send-invoice', [AppointmentController::class, 'sendInvoiceSms']);
    // doctor charge presets under v1 (full CRUD)
    Route::apiResource('doctor-charge-presets', DoctorChargePresetController::class)->only(['index','store','update','destroy']);
    Route::apiResource('owners', OwnerController::class);
    Route::apiResource('veterinarians', VeterinarianController::class);
    Route::apiResource('medicines', MedicineController::class);
    Route::apiResource('appointments', AppointmentController::class);
    Route::get('patient-reports', [PatientReportController::class, 'index']);
    Route::post('patient-reports/sync', [PatientReportController::class, 'sync']);
});
